<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('Payments', function (Blueprint $table) {
            $table->unsignedBigInteger('Coupon_id')->nullable()->after('Subscription_id');
            $table->foreign('Coupon_id')->references('Coupon_id')->on('coupons')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('Payments', function (Blueprint $table) {
            $table->dropForeign(['Coupon_id']);
            $table->dropColumn('Coupon_id');
        });
    }
};
